 ; Ŀ
 ;   Snatch - install an isometric penetration symbol.                     
 ;   Copyright 1996, 2008, 2010 by Rocket Software Ltd.                    
 ;   Sorry.                                                                
 ; 

 ; Ŀ
 ;   Clam - draw some lines.                                               
 ; 
 (DEFUN CLAM (pa quanta scala / incr angg p1 p2)
  (setq incr (/ pi 6))
  (setq angg (* incr quanta))
  (setq p1 (polar pa angg (* scala 4)))
  (setq p2 (polar pa angg (* scala 7)))
  (command "line" p1 p2 "")
  (setq angg (* incr (+ 6 quanta)))
  (setq p1 (polar pa angg (* scala 4)))
  (setq p2 (polar pa angg (* scala 7)))
  (command "line" p1 p2 ""))
 ; Ŀ
 ;   Clam end.                                                             
 ; 

 ; Ŀ
 ;   Snatch.                                                               
 ; 
 (DEFUN C:SNATCH (/ isopln dimscl radd incr 4dist 2dist pa pb linam pair
                                                             enampt tr1 tr2)
  (setvar "cmdecho" 0)
  (command ".undo" "be")
  (setq isopln (getvar "snapstyl"))
  (if (= isopln 0) (setvar "snapstyl" 1))
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq dimscl (misps))
      (setq dimscl (getvar "dimscale")))
 ; Ŀ
 ;   Set the ellipse radius.                                               
 ; 
  (setq radd (* 4 dimscl))
  (setq incr (/ pi 6))
 ; Ŀ
 ;   And a couple of other distances.                                      
 ; 
  (setq 4dist (* dimscl 4))
  (setq 2dist (* dimscl 2))
 ; Ŀ
 ;   Get an insertion point.                                               
 ; 
  (setq pa (getpoint "Penetration: "))
  (setq pb (osnap pa "Nearest"))
  (if pb (setq pa pb))
  (if (setq linam (nentselp pa))
      (setq linam (car linam)))
 ; Ŀ
 ;   Draw the ellipse.                                                     
 ; 
  (command "ellipse" "i" pa radd)
  (setq pair (getvar "snapisopair"))
 ; Ŀ
 ;   Isoplane 0.                                                           
 ; 
  (cond ((= pair 0)
         (setq enampt (list (entlast) (polar pa (* incr 7) 4dist)))
         (command "line" (setq pb (polar pa (* incr 11) 2dist))
                         (polar pb (* incr 7) radd) "")
         (setq tr1 (entlast))
         (command "line" (setq pb (polar pa (* incr 5) 2dist))
                         (polar pb (* incr 7) radd) "")
         (setq tr2 (entlast))
         (command "trim" tr1 tr2 "" enampt "")
         (entdel tr1)
         (entdel tr2)
         (clam pa 3 dimscl)
         (clam pa 5 dimscl)
         (command "break" (list linam pa)
                          (polar pa incr (* dimscl 2.8284))))
 ; Ŀ
 ;   Isoplane 1.                                                           
 ; 
        ((= pair 1)
         (setq enampt (list (entlast) (polar pa (/ pi 2) 4dist)))
         (command "line" (polar pa pi 2dist)
                         (polar (polar pa pi 2dist) (/ pi 2) radd) "")
         (setq tr1 (entlast))
         (command "line" (polar pa 0 2dist)
                         (polar (polar pa 0 2dist) (/ pi 2) radd) "")
         (setq tr2 (entlast))
         (command "trim" tr1 tr2 "" enampt "")
         (entdel tr1)
         (entdel tr2)
         (clam pa 1 dimscl)
         (clam pa 5 dimscl)
         (command "break" (list linam pa)
                          (polar pa (* incr 9) (* dimscl 2.8284))))
 ; Ŀ
 ;   Isoplane 2.                                                           
 ; 
        ((= pair 2)
         (setq enampt (list (entlast) (polar pa (* incr 11) 4dist)))
         (command "line" (setq pb (polar pa (* incr 7) 2dist))
                         (polar pb (* incr 11) radd) "")
         (setq tr1 (entlast))
         (command "line" (setq pb (polar pa (* incr 1) 2dist))
                         (polar pb (* incr 11) radd) "")
         (setq tr2 (entlast))
         (command "trim" tr1 tr2 "" enampt "")
         (entdel tr1)
         (entdel tr2)
         (clam pa 3 dimscl)
         (clam pa 1 dimscl)
         (command "break" (list linam pa)
                          (polar pa (* incr 5) (* dimscl 2.8284)))))
 ; Ŀ
 ;   End neatly.                                                           
 ; 
  (setvar "snapstyl" isopln)
  (command ".undo" "end")
 (princ))